/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_create_rdma_window.c,v 1.11 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <unistd.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "tcp.h"
#include "packet.h"
#include "rdma.h"

mx_return_t
mx_create_rdma_window(mx_endpoint_t endpoint,
                      mx_segment_t *segment_list,
                      uint32_t segment_count,
                      mx_rdma_window_flag_t flags,
                      uint32_t *window_handle){
  int ret;

  if (segment_list == NULL){
    return MX_BAD_SEG_LIST;
  }

  if (segment_count != 1){
    return MX_BAD_SEG_CNT;
  }

  if (flags & ~(MX_RDMA_READ | MX_RDMA_WRITE)) {
    return MX_BAD_BAD_BAD;
  }

  pthread_mutex_lock(&Mx_po_lock);
  ret = mx_add_window_handle(endpoint,
                             MX_UINT64(segment_list[0].segment_ptr),
                             segment_list[0].segment_length,
                             flags);
  mx_rdma_allow(MX_UINT64(segment_list[0].segment_ptr),
                segment_list[0].segment_length,
                flags);

  pthread_mutex_unlock(&Mx_po_lock);
  if (ret == -1){
    return MX_BAD_BAD_BAD;
  }

  *window_handle = ret;

  return MX_SUCCESS;
}
